Su_25UTG =  {

    Name                 =   'Su-25UTG',
    DisplayName            = _('Su-25UTG'),
	HumanCockpit = true,
	HumanCockpitPath = "./Mods/aircraft/Flaming Cliffs/Cockpit/KneeboardLeft/",

    Picture             = "Su-25T.png",
    Rate                 = 40, 
    Shape                 = "Su-25T",
	input_profile_entry = 	"Su-25UTG",

    shape_table_data     =
    {
        {
            file       = 'Su-25T';
            life       = 20; 
            vis        = 3;  
            desrt    = 'Su-25T-oblomok'; 
            fire       = {300, 2}; 
            username = 'Su-25UTG';
            index    =  WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
			positioning = "BYNORMAL";
        },
		{
			name  		= "Su-25T-oblomok";
			file  		= "Su-25T-oblomok";
			fire  		= { 240, 2};
		},

    },

	net_animation = {
        0, -- front gear
        3, -- right gear
        5, -- left gear
        9, -- right flap
        10, -- left flap
        11, -- right aileron
        12, -- left aileron
        15, -- right elevator
        16, -- left elevator
        17, -- rudder

        38,    -- canopy
        115, -- gear door
        116, -- gear door
        117, -- gear door

        190, -- left (red) navigation wing-tip light
        191, -- right (green) navigation wing-tip light
        192, -- tail (white) light

        198, -- anticollision (flashing red) top light
        199, -- anticollision (flashing red) bottom light
        208, -- taxi light (white) right main gear door
    },

	mapclasskey = "P0091000025",
        attribute = {wsType_Air, wsType_Airplane, wsType_Battleplane, WSTYPE_PLACEHOLDER,
        "Battleplanes",
        },
    Categories = {
        },

    M_empty                     =  11496.4,    
    M_nominal                   =  14150,    
    M_max                       =  19500,   
    M_fuel_max                  =  3790,    
    H_max                       =  10000,      
	length						=	15.35,
	height						=	5.2,             
	wing_area					=	50.1,
	wing_span					=	14.36,
	wing_type 					=   1,               
	wing_tip_pos 				= 	{-2.7, -0.111, 7.3},            
	flaps_maneuver              =  1,                   
	has_speedbrake              =  true,
	RCS                         =  7,                  
	IR_emission_coeff			=	0.7,	
	IR_emission_coeff_ab		=	0,                
	stores_number               =  11,                    
    CAS_min                     =  64,                 
    V_opt                       =  180,                
    V_take_off                  =  72,                
    V_land                      =  68,                 
	V_max_sea_level				=	292,	
	V_max_h						=	271,	
	Vy_max						=	60,	
	Mach_max					=	0.82,
    Ny_min                      =  -3.0,                  
    Ny_max                      =  5.9,                  
    Ny_max_e                    =  6.5,                 
    bank_angle_max              =  60,                  
    range                       =  2250,                
    thrust_sum_max              =  9856,    
    has_afteburner              =  true,
    has_differential_stabilizer =  false,
    thrust_sum_ab               =  9856,    
    average_fuel_consumption    =  0.25,                
    is_tanker                   =  false,

    tand_gear_max                               =  0.554,   
	nose_gear_pos 				                =  {2.808, -2.15, 0},   
	nose_gear_amortizer_direct_stroke   		=  0, 
	nose_gear_amortizer_reversal_stroke  		=  0, 
	nose_gear_amortizer_normal_weight_stroke 	=  0,   
	nose_gear_wheel_diameter 	                =  0.754,
	main_gear_pos 						 	    =  {-0.714, -1.95, 1.352}, 
	main_gear_amortizer_direct_stroke	 	    =  0, 
	main_gear_amortizer_reversal_stroke  	    =  0, 
	main_gear_amortizer_normal_weight_stroke    =  0,
	main_gear_wheel_diameter 				    =  0.972, 
    brakeshute_name                          	=  4,       
	
	mechanimations = {
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0.9, "in", 1.96 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "in", 1.87 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "JettisonCanopy", 0 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		HeadLights = { {
				Sequence = { {
						C = { { "Arg", 208, "to", 0, "in", 0.3 }, { "Arg", 209, "to", 0, "in", 0.3 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 0, "in", 0.3 }, { "Arg", 209, "to", 0, "in", 0.3 } }
					} },
				Transition = { "Any", "Off" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 1, "in", 0.3 }, { "Arg", 209, "to", 1, "in", 0.3 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "to", 1, "in", 0.3 }, { "Arg", 209, "to", 1, "in", 0.3 } }
					} },
				Transition = { "Any", "High" }
			} }
	},

    engines_count    = 2,
	engines_nozzles = { {
			diameter = 0.01,
			elevation = 0,
			exhaust_length_ab = 0.01, 
            exhaust_length_ab_K = 0.01, 
			pos = { -3.793, -0.391, -0.716 },
			smokiness_level = 0.3,
            afterburner_circles_count = 0
		}, {
			diameter = 0.01,
			elevation = 0,
			exhaust_length_ab = 0.01, 
            exhaust_length_ab_K = 0.01, 
			pos = { -3.793, -0.391, 0.716 },
			smokiness_level = 0.3,
            afterburner_circles_count = 0
		} },
	crew_members = { {
			canopy_pos = { 3.41, 0, 0 },
			drop_canopy_name = 49,
			ejection_seat_name = 9,
			pos = { 3.029, -0.092, 0 },
			role = "pilot",
			role_display_name = "Pilot"
		} },

	fires_pos = { { -3.084, -0.595, -0.112 }, { -0.82, 0.275, 1.274 }, { -0.82, 0.275, -1.274 }, { -0.82, 0.265, 2.774 }, { -0.82, 0.265, -2.774 }, { -0.82, 0.255, 4.274 }, { -0.82, 0.255, -4.274 }, { -3.332, -0.358, 0.7284 }, { -3.332, -0.358, -0.728 }, { -1.573, 0.145, -2.172 }, { -1.924, -0.04, -1.934 } },

		-- Countermeasures
	passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 256,
			-- PPR-26
			chaff = {default = 128, increment = 32, chargeSz = 1},
			-- PPI-26
			flare = {default = 128, increment = 32, chargeSz = 1}
        },

	chaff_flare_dispenser = { {
			dir = { 0, 1, 0 },
			pos = { -3.677, 1.012, -0.859 }
		}, {
			dir = { 0, 1, 0 },
			pos = { -3.677, 1.012, 0.859 }
		} },

    detection_range_max        = 250,
    radar_can_see_ground    =    true,
		CanopyGeometry = { -0.34202014332567, -0.58058609380733, -0.81915204428899, -0.23856595048166, 0.34202014332567 },
		        Geometry 	= {
            azimuth 	= {-145.0, 145.0},
            elevation 	= {-50.0, 90.0}
        },
        Sensors = {
            OPTIC = "Shkval",
            RWR = "Abstract RWR"
        },
        Countermeasures = {
            IRCM = "Sukhogruz"
        },

		HumanRadio = {
			frequency = 124.0,
			modulation = MODULATION_AM
		},
	
		Pylons =     {

        pylon(1, 0, -0.313000, -0.359000, -5.110000,
            {
                FiZ = -2,
                arg = 308,
				arg_value 	= 1,
				use_full_connector_position = true
            },
            {
			
            }
        ),
        pylon(2, 0, -0.610000, -0.325000, -4.359000,
            {
                FiZ = -3,
                arg = 309,
				arg_value 	= 1,
				use_full_connector_position = true
            },
            {
			
            }
        ),
        pylon(3, 0, -0.367000, -0.301000, -3.574000,
            {
                FiZ = -3,
                arg = 310,
            },
            {
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{ CLSID = "<CLEAN>",				  arg_value = 1},		
            }
        ),
        pylon(4, 0, -0.150000, -0.288000, -2.794000,
            {
                FiZ = -3,
                arg = 311,
				arg_value 	= 1,
				use_full_connector_position = true
            },
            {
			
            }
        ),
        pylon(5, 1, 0.072000, -0.263000, -2.042000,
            {
                FiZ = -3,
                arg = 312,
            },
            {
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(6, 0, -0.078000, -0.947000, 0.000000,
            {
                FiZ = -2,
                arg = 313,
            },
            {
				{CLSID = "froghook", arg_value = 0.10,  attach_point_position = { 0.0, 0.82, 0.0}}, -- Tailhook
            }
        ),
        pylon(7, 1, 0.072000, -0.263000, 2.042000,
            {
                FiZ = -3,
                arg = 314,
            },
            {
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(8, 0, -0.150000, -0.288000, 2.794000,
            {
                FiZ = -3,
                arg = 315,
				arg_value 	= 1,
				use_full_connector_position = true
            },
            {
            }
        ),
        pylon(9, 0, -0.367000, -0.301000, 3.574000,
            {
                FiZ = -3,
                arg = 316,
            },
            {
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"},-- Fuel tank 800L Wing
				{ CLSID = "<CLEAN>",				  arg_value = 1},
            }
        ),
        pylon(10, 0, -0.610000, -0.325000, 4.359000,
            {
                FiZ = -3,
                arg = 317,
				arg_value 	= 1,
				use_full_connector_position = true
            },
            {
            }
        ),
        pylon(11, 0, -0.313000, -0.359000, 5.110000,
            {
                FiZ = -2,
                arg = 318,
				arg_value 	= 1,
				use_full_connector_position = true
            },
            {
            }
        ),
},

	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories

    WorldID =  WSTYPE_PLACEHOLDER, 

		Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
		},


	Tasks = {
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
        aircraft_task(SEAD),
        aircraft_task(AFAC),
		aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAS),

    SFM_Data = {
		aerodynamics = 
		{
			Cy0	=	0.1,
			Mzalfa	=	6.6,
			Mzalfadt	=	1,
			kjx	=	2.25,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_brk = 0.06,
			cx_flap = 0.06,
			cx_gear = 0.012,
			cy_flap = 0.65,
			table_data  = {
			--      M	 Cx0		 Cya			B				B4	      Omxmax	Aldop	Cymax

				{0.0,	0.038,		0.09,			0.051,			0.0165,		0.1,	 20,	 1.40,	},
				{0.2,	0.038,		0.09,			0.051,			0.0165,		0.8,	 20,	 1.40,	},
				{0.3,	0.038,		0.09,			0.051,			0.022,		1.2,	 20,	 1.40,	},
				{0.4,	0.038,		0.09,			0.051,			0.022,		1.575,	 19,	 1.35,	},
				{0.5,	0.038,		0.09,			0.051,			0.022,		1.95,	 18,	 1.3,	},
				{0.6,	0.040,		0.09,			0.059,			0.036,		2.325,	 11,	 1.14,	},
				{0.7,	0.052,		0.09,			0.072,			0.10,		2.625,	 8,	 	 0.9,	},
				{0.8,	0.082,		0.09,			0.180,			0.16,		2.625,	 3,	 	 0.5,   },
				{1.1,	0.160,		0.09,			0.200,			0.20,		2.625,	 1,	 	 0.3    },
			}
		}, -- end of aerodynamics//
		
		engine = {
			ForsRUD = 1,
			MaksRUD = 1,
			MaxRUD = 1,
			MinRUD = 0,
			Nmg = 34.00001,
			Startup_Duration = 35,
			cefor = 0.37,
			cemax = 0.37,
			dcx_eng = 0.014,
			dpdh_f = 12000,
			dpdh_m = 4500,
			hMaxEng = 23.5,
			table_data = {
			{ 0, 98952.8, 81967.2 }, 
			{ 0.1, 96424.4, 72180 }, 
			{ 0.2, 95130.8, 62600 }, 
			{ 0.3, 94778, 53520 }, 
			{ 0.4, 95130.8, 45160 }, 
			{ 0.5, 96424.4, 37780 }, 
			{ 0.6, 98952.8, 31860 }, 
			{ 0.7, 104382, 27920 }, 
			{ 0.8, 116808.4, 26520 }, 
			{ 0.9, 124234.8, 26520 }, 
			{ 1, 124234.8, 26520 } },
			type = "TurboJet"
		}
    },

	Damage = {
	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 8, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},

	DamageParts = 
	{  
		[1] = "Su-25T-oblomok-wing-l", -- wing R
		[2] = "Su-25T-oblomok-wing-r", -- wing L
	},
---------------------------------------------------------------------------------------------------------------------------------------------
	lights_data = {
		lights = {
			[2] = {
				lights = { {
						angle_change_rate = 1.3962634015955,
						angle_max = 0.34906585039887,
						angle_min = 0.26179938779915,
						argument = -1,
						color = { 255, 201, 125, 0.3 },
						cooldown_t = 0.45,
						direction = {
							azimuth = -0.051,
							elevation = 0.226
						},
						intensity_max = 4000,
						movable = false,
						position = { -0.975, -0.248, -6.932 },
						power_up_t = 0.9,
						typename = "Spot"
					}, {
						angle_change_rate = 1.3962634015955,
						angle_max = 0.34906585039887,
						angle_min = 0.26179938779915,
						argument = -1,
						color = { 255, 201, 125, 0.3 },
						cooldown_t = 0.45,
						direction = {
							azimuth = -0.085,
							elevation = 0.226
						},
						intensity_max = 4000,
						movable = false,
						position = { -0.975, -0.248, 6.932 },
						power_up_t = 0.9,
						typename = "Spot"
					} },
				typename = "collection"
			},
			[3] = {
				lights = { {
						argument = 192,
						color = { 1, 1, 1, 0.17 },
						connector = "BANO_0",
						position = { -6.079, 2.896, 0 },
						range = 4.6,
						typename = "omnilight"
					}, {
						angle_max = 2.7925268031909,
						angle_min = 1.5707963267949,
						argument = 190,
						color = { 1, 0.05, 0.15, 0.17 },
						connector = "BANO_1",
						controller = "Strobe",
						direction = {
							azimuth = -0.5235987755983,
							elevation = 0
						},
						mode = 0,
						period = 2.5,
						phase_shift = 0,
						position = { -1.516, -0.026, -7.249 },
						power_up_t = 0.3,
						range = 18,
						reduced_flash_time = 0.333,
						typename = "Spot"
					}, {
						angle_max = 2.7925268031909,
						angle_min = 1.5707963267949,
						argument = 191,
						color = { 0, 0.894, 0.6, 0.17 },
						connector = "BANO_2",
						controller = "Strobe",
						direction = {
							azimuth = 0.5235987755983,
							elevation = 0
						},
						mode = 0,
						period = 2.5,
						phase_shift = 0.5,
						position = { -1.516, -0.026, 7.249 },
						power_up_t = 0.3,
						range = 18,
						reduced_flash_time = 0.333,
						typename = "Spot"
					} },
				typename = "collection"
			},
			[6] = {
				lights = { {
						angle_change_rate = -1.3962634015955,
						angle_max = 1.7453292519943,
						argument = -1,
						color = { 255, 201, 125, 0.12 },
						cooldown_t = 0.45,
						direction = {
							azimuth = -0.051,
							elevation = 0.226
						},
						intensity_max = 750,
						movable = false,
						position = { -0.975, -0.248, -6.932 },
						power_up_t = 0.9,
						typename = "Spot"
					}, {
						angle_change_rate = -1.3962634015955,
						angle_max = 1.7453292519943,
						argument = -1,
						color = { 255, 201, 125, 0.12 },
						cooldown_t = 0.45,
						direction = {
							azimuth = -0.085,
							elevation = 0.226
						},
						intensity_max = 750,
						movable = false,
						position = { -0.975, -0.248, 6.932 },
						power_up_t = 0.9,
						typename = "Spot"
					} },
				typename = "collection"
			},
			[9] = {
				lights = { {
						argument = 69,
						typename = "argumentlight"
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},
}

add_aircraft(Su_25UTG)
